/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.dimensions.DimensionHandler;

public class CmdDimensions
extends CommandNoppesBase {
    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public String getDescription() {
        return "World operations";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "world";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 3) {
            TreeSet<Integer> s = new TreeSet<Integer>();
            Object object = DimensionManager.getIDs();
            int n = ((Integer[])object).length;
            for (int i = 0; i < n; ++i) {
                int id = object[i];
                if (DimensionHandler.getInstance().isDelete(id)) continue;
                s.add(id);
            }
            s.add(-1);
            s.add(1);
            object = s.iterator();
            while (object.hasNext()) {
                int id = (Integer)object.next();
                list.add("" + id);
            }
        } else if (args.length >= 4 && args.length <= 6) {
            list.add("~");
        }
        return list;
    }

    @CommandNoppesBase.SubCommand(desc="Set spawn block in dimension", permission=2)
    public void setspawn(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        double dz;
        double dy;
        double dx;
        if (sender == null) {
            return;
        }
        int id = sender.func_130014_f_().field_73011_w.getDimension();
        int x = sender.func_180425_c().func_177958_n();
        int y = sender.func_180425_c().func_177956_o() + 1;
        int z = sender.func_180425_c().func_177952_p();
        if (args.length == 3) {
            try {
                dx = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177958_n(), (String)args[0], (boolean)true).func_179628_a();
                dy = CmdDimensions.func_175767_a((double)sender.func_180425_c().func_177956_o(), (String)args[1], (int)0, (int)255, (boolean)false).func_179628_a();
                dz = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177952_p(), (String)args[2], (boolean)true).func_179628_a();
                x = (int)dx;
                y = (int)dy;
                z = (int)dz;
            }
            catch (NumberFormatException e) {
                LogWriter.error(e);
            }
        }
        if (args.length == 4) {
            try {
                id = Integer.parseInt(args[0]);
                dx = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177958_n(), (String)args[1], (boolean)true).func_179628_a();
                dy = CmdDimensions.func_175767_a((double)sender.func_180425_c().func_177956_o(), (String)args[2], (int)0, (int)255, (boolean)false).func_179628_a();
                dz = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177952_p(), (String)args[3], (boolean)true).func_179628_a();
                x = (int)dx;
                y = (int)dy;
                z = (int)dz;
            }
            catch (NumberFormatException e) {
                LogWriter.error(e);
            }
        }
        if (!DimensionManager.isDimensionRegistered((int)id)) {
            throw new CommandException("DimensionID: " + id + " - not found", new Object[0]);
        }
        BlockPos pos = new BlockPos(x, y, z);
        DimensionManager.getProvider((int)id).setSpawnPoint(pos);
        DimensionManager.getWorld((int)id).func_175652_B(pos);
        server.func_184103_al().func_148540_a((Packet)new SPacketSpawnPosition(pos));
        sender.func_145747_a((ITextComponent)new TextComponentString("Set new spawn pos: [" + x + ", " + y + ", " + z + "] in dimension ID: " + id));
    }

    @CommandNoppesBase.SubCommand(desc="Transfer player to dimension", usage="<player> <dimensionID>", permission=2)
    public void tp(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int id;
        EntityPlayerMP player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        try {
            id = Integer.parseInt(args[1]);
            if (!DimensionManager.isDimensionRegistered((int)id) || DimensionHandler.getInstance().isDelete(id)) {
                throw new CommandException("DimensionID: " + id + " - not found", new Object[0]);
            }
        }
        catch (NumberFormatException ex) {
            throw new CommandException("DimensionID \"" + args[1] + "\" - must be an integer", new Object[0]);
        }
        WorldServer world = Objects.requireNonNull(sender.func_184102_h()).func_71218_a(id);
        BlockPos coords = world.func_180504_m();
        if (coords == null) {
            coords = world.func_175694_M();
        }
        if (!world.func_175623_d(coords)) {
            coords = world.func_175672_r(coords);
        } else if (!world.func_175623_d(coords.func_177984_a())) {
            while (world.func_175623_d(coords) && coords.func_177956_o() > 0) {
                coords = coords.func_177977_b();
            }
            if (coords.func_177956_o() == 0) {
                coords = world.func_175672_r(coords);
            }
        }
        double x = coords.func_177958_n();
        double y = coords.func_177956_o();
        double z = coords.func_177952_p();
        if (args.length == 5) {
            try {
                double dx = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177958_n(), (String)args[2], (boolean)true).func_179628_a();
                double dy = CmdDimensions.func_175767_a((double)sender.func_180425_c().func_177956_o(), (String)args[3], (int)0, (int)255, (boolean)false).func_179628_a();
                double dz = CmdDimensions.func_175770_a((double)sender.func_180425_c().func_177952_p(), (String)args[4], (boolean)true).func_179628_a();
                x = dx;
                y = dy;
                z = dz;
            }
            catch (NumberFormatException e) {
                LogWriter.error(e);
            }
        }
        NoppesUtilPlayer.teleportPlayer(player, x, y, z, id, player.field_70177_z, player.field_70125_A);
    }
}

